/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.service.io.http.impl;

import com.starbase.core.DTOFactory;
import com.starbase.core.communication.api.CommunicationService;
import com.starbase.core.communication.dto.AddressDTO;
import com.starbase.core.crypto.api.CipherMode;
import com.starbase.core.crypto.api.CryptoService;
import com.starbase.core.crypto.api.CryptoServiceAware;
import com.starbase.core.mapping.api.MappingService;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.messaging.api.MessageConsumer;
import com.starbase.core.messaging.api.MessagingService;
import com.starbase.core.messaging.api.MessagingServiceAware;
import com.starbase.core.messaging.dto.EventDTO;
import com.starbase.core.types.http.HttpDTO;
import com.starbase.core.types.http.HttpMethod;
import com.starbase.service.io.http.Activator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;

public class HTTPCommunicationServiceImpl
implements MessageConsumer,
CommunicationService,
MessagingServiceAware,
CryptoServiceAware,
MappingServiceAware {
    private MessagingService messagingService;
    private CryptoService cryptoService;
    private MappingService mappingService;

    public void push(EventDTO event, String topic) {
        this.sendMessage(null, event);
    }

    public boolean sendMessage(AddressDTO address, EventDTO event) {
        CloseableHttpAsyncClient thttpasyncclient = null;
        try {
            SSLContext sslContext = this.cryptoService.getSSLContext();
            thttpasyncclient = HttpAsyncClients.custom().setSSLContext(sslContext).build();
        }
        catch (NullPointerException e) {
            thttpasyncclient = HttpAsyncClients.createDefault();
        }
        CloseableHttpAsyncClient httpasyncclient = thttpasyncclient;
        httpasyncclient.start();
        HttpDTO httpDto = null;
        try {
            Object o = this.mappingService.mapToObject(event.getBody(), HttpDTO.class);
            if (o.getClass().equals(HttpDTO.class)) {
                httpDto = (HttpDTO)o;
            }
        }
        catch (Exception e1) {
            Activator.getLog().log(4, "send http get to " + event.getBody());
            HttpDTO httpDto1 = new HttpDTO();
            httpDto1.setUrl(event.getBody());
            return this.get(httpasyncclient, httpDto1, event);
        }
        String url = null;
        if (!httpDto.getUrl().isEmpty()) {
            url = httpDto.getUrl();
        } else if (address != null) {
            url = address.getTo();
        }
        if (url == null) {
            Activator.getLog().log(1, "Invalid http request url.");
            return false;
        }
        if (httpDto.getMethod().equals((Object)HttpMethod.GET)) {
            Activator.getLog().log(4, "send http get to " + url);
            return this.get(httpasyncclient, httpDto, event);
        }
        if (httpDto.getMethod().equals((Object)HttpMethod.POST)) {
            Activator.getLog().log(4, "send http post to " + url);
            return this.post(httpasyncclient, httpDto, event);
        }
        if (httpDto.getMethod().equals((Object)HttpMethod.PUT)) {
            Activator.getLog().log(4, "send http put to " + url);
            return this.put(httpasyncclient, httpDto, event);
        }
        if (httpDto.getMethod().equals((Object)HttpMethod.DELETE)) {
            Activator.getLog().log(4, "send http delete to " + url);
            return this.delete(httpasyncclient, httpDto, event);
        }
        Activator.getLog().log(1, "Invalid http method.");
        return false;
    }

    private boolean get(CloseableHttpAsyncClient httpasyncclient, HttpDTO httpDto, EventDTO event) {
        HttpGet request = new HttpGet(httpDto.getUrl());
        this.executeRequest(httpasyncclient, (HttpRequestBase)request, httpDto, event);
        return true;
    }

    private boolean post(CloseableHttpAsyncClient httpasyncclient, HttpDTO httpDto, EventDTO event) {
        HttpPost request = new HttpPost(httpDto.getUrl());
        StringEntity entity = new StringEntity(httpDto.getContent(), ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)entity);
        this.executeRequest(httpasyncclient, (HttpRequestBase)request, httpDto, event);
        return true;
    }

    private boolean put(CloseableHttpAsyncClient httpasyncclient, HttpDTO httpDto, EventDTO event) {
        HttpPut request = new HttpPut(httpDto.getUrl());
        StringEntity entity = new StringEntity(httpDto.getContent(), ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)entity);
        this.executeRequest(httpasyncclient, (HttpRequestBase)request, httpDto, event);
        return true;
    }

    private boolean delete(CloseableHttpAsyncClient httpasyncclient, HttpDTO httpDto, EventDTO event) {
        HttpDelete request = new HttpDelete(httpDto.getUrl());
        this.executeRequest(httpasyncclient, (HttpRequestBase)request, httpDto, event);
        return true;
    }

    private void executeRequest(final CloseableHttpAsyncClient httpasyncclient, HttpRequestBase request, HttpDTO httpDto, final EventDTO event) {
        request.setHeader("Accept", "application/json");
        request.setHeader("Content-Type", "application/json");
        if (httpDto.getAuthToken() != null && !httpDto.getAuthToken().equals("")) {
            request.setHeader("Authorization", "Bearer " + httpDto.getAuthToken());
        } else if (httpDto.getUsername() != null && httpDto.getPassword() != null) {
            String encoding = Base64.getEncoder().encodeToString((httpDto.getUsername() + ":" + httpDto.getPassword()).getBytes());
            request.setHeader("Authorization", "Basic " + encoding);
        }
        httpasyncclient.execute((HttpUriRequest)request, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void failed(Exception ex) {
                if (ex instanceof SSLHandshakeException) {
                    Activator.getLog().log(3, "ssl handshake problem", (Throwable)ex);
                } else {
                    Activator.getLog().log(2, "unable to get data", (Throwable)ex);
                }
                try {
                    httpasyncclient.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void completed(HttpResponse resp) {
                ByteArrayOutputStream result = null;
                try {
                    int length;
                    InputStream inputStream = resp.getEntity().getContent();
                    result = new ByteArrayOutputStream();
                    byte[] buffer = new byte[(int)(resp.getEntity().getContentLength() * 2L)];
                    while ((length = inputStream.read(buffer)) != -1) {
                        result.write(buffer, 0, length);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                String content = "error";
                try {
                    content = result.toString("UTF-8");
                }
                catch (UnsupportedEncodingException buffer) {
                    // empty catch block
                }
                EventDTO newEvent = DTOFactory.createEvent((String)event.getTo(), (String)event.getFrom(), (String)event.getTopic(), (CipherMode)CipherMode.PLAIN, (String)content);
                if (event.getTopic().equals("update")) {
                    HTTPCommunicationServiceImpl.this.messagingService.publishMessage("in.http." + event.getTo(), newEvent);
                } else {
                    Activator.getLog().log(4, "Publishing http response to in.http." + event.getTopic());
                    System.out.println(HTTPCommunicationServiceImpl.this.messagingService.toString());
                    HTTPCommunicationServiceImpl.this.messagingService.publishMessage("in.http." + event.getTopic(), newEvent);
                }
                try {
                    httpasyncclient.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void cancelled() {
                Activator.getLog().log(2, "http call cancelled");
                try {
                    httpasyncclient.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public void setMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    public void setMappingService(MappingService mappingService) {
        this.mappingService = mappingService;
    }
}

