/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.service.io.mqtt;

import com.starbase.core.communication.api.AddressServiceAware;
import com.starbase.core.communication.api.CommunicationService;
import com.starbase.core.config.api.ConfiguredService;
import com.starbase.core.crypto.api.CryptoServiceAware;
import com.starbase.core.logger.LogServiceTracker;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.messaging.api.MessageConsumer;
import com.starbase.core.messaging.api.MessagingService;
import com.starbase.core.messaging.api.MessagingServiceAware;
import com.starbase.service.io.mqtt.impl.MQTTCommunicationServiceImpl;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogService;

public class Activator
implements BundleActivator {
    public static final String SERVICE_PID = "com.starbase.service.io.mqtt";
    public static final String MyMqttID = "this.mqtt";
    private static BundleContext context;
    private static LogServiceTracker logServiceTracker;
    private static MQTTCommunicationServiceImpl mqttService;
    private static String DEVICE_ID;

    public static String getDEVICE_ID() {
        return DEVICE_ID;
    }

    public static BundleContext getContext() {
        return context;
    }

    public static LogService getLog() {
        return logServiceTracker == null ? null : logServiceTracker.getService();
    }

    public static MessagingService getMessagingService() {
        if (mqttService != null) {
            return mqttService.getMessagingService();
        }
        return null;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        DEVICE_ID = bundleContext.getProperty("com.starbase.id");
        logServiceTracker = new LogServiceTracker(context);
        logServiceTracker.open();
        mqttService = new MQTTCommunicationServiceImpl();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("service.pid", SERVICE_PID);
        ((Dictionary)properties).put("type", "JSON");
        ((Dictionary)properties).put("topic", new String[]{"out.mqtt.*"});
        context.registerService(new String[]{MessageConsumer.class.getName(), CommunicationService.class.getName(), ConfiguredService.class.getName(), ManagedService.class.getName(), MessagingServiceAware.class.getName(), AddressServiceAware.class.getName(), MappingServiceAware.class.getName(), CryptoServiceAware.class.getName()}, (Object)mqttService, properties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        mqttService.disconnect();
        logServiceTracker.close();
        context = null;
    }
}

