/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.service.io.mqtt.impl;

import com.starbase.core.communication.api.AddressService;
import com.starbase.core.communication.api.AddressServiceAware;
import com.starbase.core.communication.api.CommunicationService;
import com.starbase.core.communication.dto.AddressDTO;
import com.starbase.core.config.api.ConfiguredService;
import com.starbase.core.crypto.api.CryptoService;
import com.starbase.core.crypto.api.CryptoServiceAware;
import com.starbase.core.mapping.api.MappingService;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.messaging.api.MessageConsumer;
import com.starbase.core.messaging.api.MessagingService;
import com.starbase.core.messaging.api.MessagingServiceAware;
import com.starbase.core.messaging.dto.EventDTO;
import com.starbase.service.io.mqtt.Activator;
import com.starbase.service.io.mqtt.impl.MqttPostPropertyMessageListener;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class MQTTCommunicationServiceImpl
implements MessageConsumer,
CommunicationService,
ManagedService,
ConfiguredService,
MessagingServiceAware,
AddressServiceAware,
MappingServiceAware,
CryptoServiceAware {
    private Dictionary<String, ?> configProperties;
    private Thread keepAliveThread = new Thread(new Runnable(){

        @Override
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    Thread.sleep(2000L);
                    MQTTCommunicationServiceImpl.this.checkConnection();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    });
    private boolean forceReconnect = false;
    private AddressService addressService;
    private MappingService mappingService;
    private CryptoService cryptoService;
    private MessagingService messagingService;
    MqttClient sampleClient;
    MqttConnectOptions connOpts;

    public MessagingService getMessagingService() {
        return this.messagingService;
    }

    public MQTTCommunicationServiceImpl() {
        this.keepAliveThread.start();
    }

    private void checkConnection() {
        if (this.sampleClient == null || this.connOpts == null || !this.sampleClient.isConnected() || this.forceReconnect) {
            String server = (String)this.configProperties.get("server");
            String port = (String)this.configProperties.get("port");
            String clientId = (String)this.configProperties.get("clientId");
            String username = (String)this.configProperties.get("username");
            String password = (String)this.configProperties.get("password");
            String topics = (String)this.configProperties.get("topics");
            try {
                this.sampleClient = new MqttClient(server + ":" + port, clientId, null);
            }
            catch (MqttException e1) {
                Activator.getLog().log(1, "MQTT Client Constructor Error.", (Throwable)e1);
            }
            if (this.connOpts == null) {
                this.connOpts = new MqttConnectOptions();
            }
            this.connOpts.setCleanSession(true);
            this.connOpts.setKeepAliveInterval(180);
            this.connOpts.setUserName(username);
            this.connOpts.setPassword(password.toCharArray());
            try {
                this.sampleClient.connect(this.connOpts);
                if (this.sampleClient.isConnected()) {
                    Activator.getLog().log(3, "MQTT Client connected.");
                    if (!topics.isEmpty()) {
                        String[] topicsSplit = topics.split(";");
                        for (int i = 0; i < topicsSplit.length; ++i) {
                            try {
                                this.sampleClient.subscribe(topicsSplit[i], (IMqttMessageListener)new MqttPostPropertyMessageListener());
                                continue;
                            }
                            catch (MqttException e) {
                                Activator.getLog().log(2, "MQTT Client could not subscribe for topic " + topicsSplit[i]);
                            }
                        }
                    }
                    this.forceReconnect = false;
                } else {
                    Activator.getLog().log(3, "MQTT Client could not connected. Check configuration.");
                }
            }
            catch (MqttException e1) {
                Activator.getLog().log(2, "MQTT Client Connection Error. Check configuration properties.");
            }
        }
    }

    public void disconnect() {
        this.keepAliveThread.interrupt();
        if (this.sampleClient != null && !this.sampleClient.isConnected()) {
            try {
                this.sampleClient.disconnect();
            }
            catch (MqttException mqttException) {
                // empty catch block
            }
        }
    }

    public Dictionary<String, ?> getDefaultConfiguration() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("server", "tcp://192.168.1.2");
        ((Dictionary)properties).put("port", "1883");
        ((Dictionary)properties).put("clientId", Activator.getDEVICE_ID());
        ((Dictionary)properties).put("username", "offlinemq");
        ((Dictionary)properties).put("password", "3JnApqy0QDJ64iqln1td");
        ((Dictionary)properties).put("topics", "#");
        return properties;
    }

    public void push(EventDTO event, String topic) {
        if (topic.startsWith("out.mqtt")) {
            AddressDTO toAddress = this.addressService.getAddress(event.getTo());
            this.sendMessage(toAddress, event);
        }
    }

    public boolean sendMessage(AddressDTO address, EventDTO event) {
        MqttMessage message = new MqttMessage(event.getBody().getBytes());
        message.setQos(0);
        try {
            String mqttTopic = event.getTopic().replace(".", "/");
            this.sampleClient.publish(address.getTo() + "/" + mqttTopic, message);
        }
        catch (MqttException e2) {
            Activator.getLog().log(1, "MQTT Publish Error.", (Throwable)e2);
        }
        Activator.getLog().log(4, "Publishing MQTT message to " + event.getTopic());
        return false;
    }

    public void listen(String exchangeAddress) {
    }

    public void updated(Dictionary<String, ?> newProperties) throws ConfigurationException {
        if (newProperties == null) {
            Activator.getLog().log(2, "Configuration properties are null.");
            return;
        }
        Activator.getLog().log(4, "trying to update mqtt connection settings to " + newProperties);
        if (this.configProperties != null) {
            if (newProperties.get("username") != null && !newProperties.get("username").equals(this.configProperties.get("username"))) {
                this.forceReconnect = true;
            }
            if (newProperties.get("password") != null && !newProperties.get("password").equals(this.configProperties.get("password"))) {
                this.forceReconnect = true;
            }
            if (newProperties.get("server") != null && !newProperties.get("server").equals(this.configProperties.get("server"))) {
                this.forceReconnect = true;
            }
            if (newProperties.get("clientId") != null && !newProperties.get("clientId").equals(this.configProperties.get("clientId"))) {
                this.forceReconnect = true;
            }
            if (newProperties.get("port") != null && !newProperties.get("port").equals(this.configProperties.get("port"))) {
                this.forceReconnect = true;
            }
            if (newProperties.get("topics") != null && !newProperties.get("topics").equals(this.configProperties.get("topics"))) {
                this.forceReconnect = true;
            }
        } else {
            this.forceReconnect = false;
        }
        this.configProperties = newProperties;
    }

    public void setMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    public void setAddressService(AddressService addressService) {
        this.addressService = addressService;
        AddressDTO dto = new AddressDTO();
        dto.setIdentifier("this.mqtt");
        dto.setTech("com.starbase.service.io.mqtt");
        dto.setTo("EXCHANGE_" + Activator.getDEVICE_ID());
        if (addressService.getAddress("this.mqtt") == null) {
            addressService.addAddress("this.mqtt", dto);
        } else if (!addressService.getAddress("this.mqtt").getTo().equals(dto.getTo())) {
            addressService.removeAddress("this.mqtt");
            addressService.addAddress("this.mqtt", dto);
        }
    }

    public void setMappingService(MappingService mappingService) {
        this.mappingService = mappingService;
    }

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }
}

