/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.service.io.p2p;

import com.starbase.core.communication.api.AddressServiceAware;
import com.starbase.core.communication.api.CommunicationService;
import com.starbase.core.config.api.ConfiguredService;
import com.starbase.core.crypto.api.CryptoServiceAware;
import com.starbase.core.logger.LogServiceTracker;
import com.starbase.core.mapping.api.MappingService;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.messaging.api.MessageConsumer;
import com.starbase.core.messaging.api.MessagingService;
import com.starbase.core.messaging.api.MessagingServiceAware;
import com.starbase.service.io.p2p.impl.P2PCommunicationService;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogService;

public class Activator
implements BundleActivator,
MappingServiceAware,
MessagingServiceAware {
    private static BundleContext context;
    private static LogServiceTracker logServiceTracker;
    private static MappingService mappingService;
    private static MessagingService messagingService;

    public static BundleContext getContext() {
        return context;
    }

    public static LogService getLog() {
        return logServiceTracker == null ? null : logServiceTracker.getService();
    }

    public static MappingService getMappingService() {
        return mappingService;
    }

    public static MessagingService getMessagingService() {
        return messagingService;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        logServiceTracker = new LogServiceTracker(context);
        logServiceTracker.open();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("service.pid", "com.starbase.service.io.p2p");
        ((Dictionary)properties).put("topic", new String[]{"out.p2p.*"});
        context.registerService(new String[]{MappingServiceAware.class.getName(), MessagingServiceAware.class.getName()}, (Object)this, null);
        context.registerService(new String[]{AddressServiceAware.class.getName(), MessageConsumer.class.getName(), CommunicationService.class.getName(), ConfiguredService.class.getName(), ManagedService.class.getName(), CryptoServiceAware.class.getName()}, (Object)P2PCommunicationService.getInstance(), properties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        P2PCommunicationService.getInstance().stop();
        logServiceTracker.close();
        context = null;
    }

    public void setMappingService(MappingService mappingService) {
        Activator.mappingService = mappingService;
    }

    public void setMessagingService(MessagingService messagingService) {
        Activator.messagingService = messagingService;
    }
}

