/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.service.io.p2p.impl;

import com.starbase.core.communication.dto.AddressDTO;
import com.starbase.core.crypto.api.CipherMode;
import com.starbase.core.messaging.dto.EventDTO;
import com.starbase.service.io.p2p.Activator;
import com.starbase.service.io.p2p.impl.P2PCommunicationService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;

public class MultiServerThread
implements Runnable {
    Socket socket;
    private PrintWriter out;

    public MultiServerThread(Socket s) {
        this.socket = s;
    }

    public boolean send(String data) {
        this.out.write(data + "\n");
        this.out.flush();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String inputLine;
            this.out = new PrintWriter(this.socket.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                AddressDTO sender;
                EventDTO event;
                block20: {
                    System.out.println("in> " + inputLine);
                    event = (EventDTO)Activator.getMappingService().mapToObject(inputLine, EventDTO.class);
                    sender = P2PCommunicationService.getInstance().getAddress(event.getFrom());
                    if (sender != null && sender.getTo().startsWith(this.socket.getInetAddress().getHostAddress())) break block20;
                    this.socket.close();
                    Activator.getLog().log(2, "Closing connection to " + this.socket.getInetAddress().getHostAddress() + ", sender: " + sender);
                    return;
                }
                try {
                    P2PCommunicationService.getInstance().setListener(sender, this);
                    if (Activator.getMessagingService() == null) {
                        Activator.getLog().log(1, "MessagingService is null");
                        continue;
                    }
                    AddressDTO receiver = P2PCommunicationService.getInstance().getAddress(event.getTo());
                    event.setTo(receiver.getIdentifier());
                    event.setFrom(sender.getIdentifier());
                    String fullTopic = "in.p2p." + event.getTopic();
                    if (!event.getCipherState().equals((Object)CipherMode.PLAIN)) {
                        fullTopic = event.getCipherState().toString().toLowerCase() + "." + fullTopic;
                    }
                    Activator.getLog().log(3, "Publishing to: " + fullTopic);
                    Activator.getMessagingService().publishMessage(fullTopic, event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.out.close();
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.socket.close();
            }
            catch (Exception exception) {}
        }
    }
}

