/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.service.io.p2p.impl;

import com.starbase.core.communication.api.AddressService;
import com.starbase.core.communication.api.AddressServiceAware;
import com.starbase.core.communication.api.CommunicationService;
import com.starbase.core.communication.dto.AddressDTO;
import com.starbase.core.config.api.ConfiguredService;
import com.starbase.core.crypto.api.CryptoService;
import com.starbase.core.crypto.api.CryptoServiceAware;
import com.starbase.core.exception.io.ContentTooLongException;
import com.starbase.core.messaging.api.MessageConsumer;
import com.starbase.core.messaging.dto.EventDTO;
import com.starbase.service.io.p2p.Activator;
import com.starbase.service.io.p2p.impl.ConnectionListener;
import com.starbase.service.io.p2p.impl.MultiServerThread;
import java.io.IOException;
import java.net.Socket;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class P2PCommunicationService
implements MessageConsumer,
AddressServiceAware,
CommunicationService,
ConfiguredService,
ManagedService,
CryptoServiceAware {
    private AddressService addressService;
    private Dictionary<String, ?> configProperties;
    private Map<AddressDTO, MultiServerThread> connectionThreads = new Hashtable<AddressDTO, MultiServerThread>();
    private static P2PCommunicationService instance;
    private ConnectionListener listener = new ConnectionListener();
    private CryptoService cryptoService;

    private P2PCommunicationService() {
        this.listener.start();
    }

    public static P2PCommunicationService getInstance() {
        if (instance == null) {
            instance = new P2PCommunicationService();
        }
        return instance;
    }

    public void stop() {
        this.listener.stopListener();
    }

    public void push(EventDTO event, String topic) {
        AddressDTO toAddress = this.addressService.getAddress(event.getTo());
        this.sendMessage(toAddress, event);
    }

    public boolean sendMessage(AddressDTO address, EventDTO message) {
        MultiServerThread multiServerThread = this.connectionThreads.get(address);
        if (multiServerThread == null) {
            String[] split = address.getTo().split(":");
            try {
                Socket socket = this.cryptoService.getSSLContext().getSocketFactory().createSocket(split[0], (int)Integer.valueOf(split[1]));
                multiServerThread = new MultiServerThread(socket);
                new Thread(multiServerThread).start();
                this.connectionThreads.put(address, multiServerThread);
            }
            catch (IOException | NumberFormatException e) {
                Activator.getLog().log(2, "connection to " + address.getTo() + " failed", (Throwable)e);
                return false;
            }
        }
        try {
            String newFrom = this.addressService.getAddress(message.getFrom()).getTo();
            message.setFrom(newFrom);
            String newTo = this.addressService.getAddress(message.getTo()).getTo();
            message.setTo(newTo);
        }
        catch (ContentTooLongException | NullPointerException newFrom) {
            // empty catch block
        }
        try {
            return multiServerThread.send(Activator.getMappingService().mapToString((Object)message));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public AddressDTO getAddress(String addr) {
        Set addressListByTechnology = this.addressService.getAddressListByTechnology("com.starbase.service.io.p2p").entrySet();
        for (Map.Entry entry : addressListByTechnology) {
            if (!((AddressDTO)entry.getValue()).getTo().equals(addr)) continue;
            return (AddressDTO)entry.getValue();
        }
        return null;
    }

    public void setListener(AddressDTO address, MultiServerThread socket) {
        this.connectionThreads.put(address, socket);
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties == null) {
            return;
        }
        Activator.getLog().log(3, "configuration has been updated: " + properties);
        this.configProperties = properties;
        Object port = this.configProperties.get("port");
        if (port != null) {
            this.listener.setPort(Integer.valueOf(port.toString()));
        }
    }

    public Dictionary<String, ?> getDefaultConfiguration() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("port", "1318");
        return properties;
    }

    public void setAddressService(AddressService addressService) {
        this.addressService = addressService;
    }

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    public CryptoService getCryptoService() {
        return this.cryptoService;
    }
}

