/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.service.io.serial;

import com.starbase.core.communication.api.AddressServiceAware;
import com.starbase.core.communication.api.CommunicationService;
import com.starbase.core.config.api.ConfiguredService;
import com.starbase.core.logger.LogServiceTracker;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.messaging.api.MessageConsumer;
import com.starbase.core.messaging.api.MessagingServiceAware;
import com.starbase.service.io.serial.impl.SerialCommunicationService;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogService;

public class Activator
implements BundleActivator {
    public static final String SERVICE_PID = "com.starbase.service.io.serial";
    private static BundleContext context;
    private static LogServiceTracker logServiceTracker;
    private SerialCommunicationService serial;

    public static BundleContext getContext() {
        return context;
    }

    public static String getServicePid() {
        return SERVICE_PID;
    }

    public static LogService getLog() {
        return logServiceTracker == null ? null : logServiceTracker.getService();
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        logServiceTracker = new LogServiceTracker(context);
        logServiceTracker.open();
        this.serial = new SerialCommunicationService();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("service.pid", SERVICE_PID);
        ((Dictionary)properties).put("topic", new String[]{"out.serial.*"});
        context.registerService(new String[]{MessageConsumer.class.getName(), AddressServiceAware.class.getName(), CommunicationService.class.getName(), ConfiguredService.class.getName(), ManagedService.class.getName(), MessagingServiceAware.class.getName(), MappingServiceAware.class.getName()}, (Object)this.serial, properties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.serial.disconnect();
        logServiceTracker.close();
        context = null;
    }
}

