/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.service.io.serial.impl;

import com.starbase.core.DTOFactory;
import com.starbase.core.communication.api.AddressService;
import com.starbase.core.communication.api.AddressServiceAware;
import com.starbase.core.communication.api.CommunicationService;
import com.starbase.core.communication.dto.AddressDTO;
import com.starbase.core.config.api.ConfiguredService;
import com.starbase.core.crypto.api.CipherMode;
import com.starbase.core.mapping.api.MappingService;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.messaging.api.MessageConsumer;
import com.starbase.core.messaging.api.MessagingService;
import com.starbase.core.messaging.api.MessagingServiceAware;
import com.starbase.core.messaging.dto.EventDTO;
import com.starbase.service.io.serial.Activator;
import com.starbase.service.io.serial.impl.SerialConfiguration;
import com.starbase.service.io.serial.impl.SerialController;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class SerialCommunicationService
implements MessageConsumer,
AddressServiceAware,
CommunicationService,
ManagedService,
ConfiguredService,
MessagingServiceAware,
MappingServiceAware {
    private MessagingService messagingService;
    private Dictionary<String, ?> configProperties;
    private HashMap<String, SerialController> serialControllerMap = new HashMap();
    private AddressService addressService;
    private MappingService mappingService;

    public void push(EventDTO event, String topic) {
        AddressDTO toAddress = this.addressService.getAddress(event.getTo());
        this.sendMessage(toAddress, event);
    }

    public boolean sendMessage(AddressDTO address, EventDTO event) {
        String sendMessage;
        SerialConfiguration conf = null;
        try {
            conf = new SerialConfiguration(address);
        }
        catch (Exception e) {
            Activator.getLog().log(1, "bad address format");
            return false;
        }
        if (!this.configProperties.get("allowed_ports").toString().contains(conf.getPort())) {
            Activator.getLog().log(1, "port " + conf.getPort() + " not allowed");
            return false;
        }
        if (!this.serialControllerMap.containsKey(conf.getAddressDTO().getTo())) {
            SerialController crtl = new SerialController();
            try {
                crtl.connect(this, conf);
            }
            catch (Exception e) {
                Activator.getLog().log(1, "error while opening serial port", (Throwable)e);
                return false;
            }
            this.serialControllerMap.put(conf.getAddressDTO().getTo(), crtl);
        }
        if (event.getBody().equals("")) {
            return true;
        }
        if (this.configProperties.get("starbase_device_ports").toString().contains(conf.getPort())) {
            try {
                sendMessage = this.mappingService.mapToString((Object)event);
            }
            catch (Exception e) {
                Activator.getLog().log(1, "mapping error", (Throwable)e);
                return false;
            }
        } else {
            sendMessage = event.getBody();
        }
        try {
            if (conf.getPort().contains("rfcomm0")) {
                System.out.println("\n" + sendMessage + "\n");
                if (sendMessage.length() > 1004) {
                    sendMessage = "-----BEGIN-BT-MESSAGE-----" + sendMessage + "-----END-BT-MESSAGE-----";
                }
                this.serialControllerMap.get(conf.getAddressDTO().getTo()).writeString(sendMessage);
            } else {
                this.serialControllerMap.get(conf.getAddressDTO().getTo()).write(sendMessage);
            }
            return true;
        }
        catch (Exception e) {
            Activator.getLog().log(1, "error while writing to serial port", (Throwable)e);
            return false;
        }
    }

    protected void publishMessage(SerialConfiguration conf, String message) {
        AddressDTO address = conf.getAddressDTO();
        if (this.messagingService == null) {
            Activator.getLog().log(1, "messaging service missing");
            return;
        }
        EventDTO event = null;
        if (this.configProperties.get("starbase_device_ports").toString().contains(conf.getPort())) {
            try {
                event = (EventDTO)this.mappingService.mapToObject(message, EventDTO.class);
            }
            catch (Exception e) {
                Activator.getLog().log(1, "mapping error", (Throwable)e);
            }
            if (event.getCipherState().equals((Object)CipherMode.PLAIN)) {
                if (!this.messagingService.publishMessage("in.serial." + address.getIdentifier() + "." + event.getTopic(), event)) {
                    Activator.getLog().log(1, "unable to publish message, messaging service failed");
                } else if (!event.getTopic().contains("frequencies")) {
                    Activator.getLog().log(3, "Incoming message publishing to: in.serial." + address.getIdentifier() + "." + event.getTopic());
                }
            } else if (!this.messagingService.publishMessage(event.getCipherState().toString().toLowerCase() + ".in.serial." + address.getIdentifier() + "." + event.getTopic(), event)) {
                Activator.getLog().log(1, "unable to publish message, messaging service failed");
            } else {
                Activator.getLog().log(3, "Incoming message publishing to: " + event.getCipherState().toString().toLowerCase() + ".in.serial." + address.getIdentifier() + "." + event.getTopic());
            }
        } else {
            event = DTOFactory.createEvent((String)"", (String)address.getIdentifier(), (String)"", (CipherMode)CipherMode.PLAIN, (String)message);
            if (!this.messagingService.publishMessage("in.serial." + address.getIdentifier(), event)) {
                Activator.getLog().log(1, "unable to publish message, messaging service failed");
            } else {
                Activator.getLog().log(3, "Incoming message publishing to: in.serial." + address.getIdentifier());
            }
        }
    }

    public void disconnect() {
        for (Map.Entry<String, SerialController> entry : this.serialControllerMap.entrySet()) {
            entry.getValue().disconnect();
        }
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        Activator.getLog().log(3, "configuration has been updated: " + properties);
        if (properties != null) {
            this.configProperties = properties;
        }
    }

    public Dictionary<String, ?> getDefaultConfiguration() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("allowed_ports", "/dev/ttyUSB0;/dev/ttyAMA0;/dev/ttyACM0;/dev/rfcomm0");
        ((Dictionary)properties).put("starbase_device_ports", "/dev/ttyAMA0;/dev/rfcomm0");
        return properties;
    }

    public void setMessagingService(MessagingService messagingService) {
        Activator.getLog().log(4, "injected messaging service");
        this.messagingService = messagingService;
    }

    public void setAddressService(AddressService addressService) {
        this.addressService = addressService;
    }

    public void setMappingService(MappingService mappingService) {
        this.mappingService = mappingService;
    }
}

