/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.service.io.serial.impl;

import com.starbase.service.io.serial.Activator;
import com.starbase.service.io.serial.impl.SerialCommunicationService;
import com.starbase.service.io.serial.impl.SerialConfiguration;
import gnu.io.NRSerialPort;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class SerialController {
    private OutputStream out;
    private boolean active = true;
    private Thread runner;

    public void connect(final SerialCommunicationService sv, final SerialConfiguration conf) throws Exception {
        final NRSerialPort serial = new NRSerialPort(conf.getPort(), conf.getBaud());
        if (!serial.connect()) {
            Activator.getLog().log(1, "error while connecting to serial port " + conf.getPort());
            return;
        }
        Activator.getLog().log(4, "Connecting to serial port " + conf.getPort());
        this.runner = new Thread(new Runnable(){

            @Override
            public void run() {
                BufferedReader in = new BufferedReader(new InputStreamReader(serial.getInputStream()));
                String line = null;
                Thread.currentThread();
                do {
                    try {
                        line = in.readLine();
                        if (sv == null) continue;
                        sv.publishMessage(conf, new String(line));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                } while (!Thread.interrupted() && SerialController.this.active);
            }
        });
        this.runner.start();
        this.out = new DataOutputStream(serial.getOutputStream());
    }

    public void write(String string) throws Exception {
        byte[] data;
        for (byte c : data = string.getBytes()) {
            this.out.write(c);
        }
        this.out.write(10);
    }

    public void writeString(String string) throws Exception {
        byte[] data = string.getBytes();
        this.out.write(data);
    }

    public void disconnect() {
        this.active = false;
        this.runner.interrupt();
    }
}

