/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.service.io.system.linux.impl;

import com.starbase.core.DTOFactory;
import com.starbase.core.communication.api.CommunicationService;
import com.starbase.core.communication.dto.AddressDTO;
import com.starbase.core.crypto.api.CipherMode;
import com.starbase.core.mapping.api.MappingService;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.messaging.api.MessageConsumer;
import com.starbase.core.messaging.api.MessagingService;
import com.starbase.core.messaging.api.MessagingServiceAware;
import com.starbase.core.messaging.dto.EventDTO;
import com.starbase.core.types.config.WLANConfigDTO;
import com.starbase.service.io.system.linux.Activator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class LinuxSystemServiceImpl
implements MessageConsumer,
CommunicationService,
MappingServiceAware,
MessagingServiceAware {
    private MappingService mappingService;
    private MessagingService messagingService;

    public void push(EventDTO event, String topic) {
        this.sendMessage(null, event);
    }

    public boolean sendMessage(AddressDTO address, EventDTO event) {
        if (event.getTopic().startsWith("command.execute.response")) {
            String result = "";
            try {
                String s;
                Process p = Runtime.getRuntime().exec(event.getBody());
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((s = br.readLine()) != null) {
                    result = result + s;
                }
                p.waitFor();
                p.destroy();
            }
            catch (Exception e) {
                Activator.getLog().log(1, "Error while executing linux shell command: " + event.getBody() + "\n", (Throwable)e);
            }
            EventDTO newEvent = DTOFactory.createEvent((String)event.getTo(), (String)event.getFrom(), (String)event.getTopic(), (CipherMode)CipherMode.PLAIN, (String)result);
            Activator.getLog().log(4, "Publishing http response to in.system.linux." + event.getTopic());
            this.messagingService.publishMessage("in.system.linux." + event.getTopic(), newEvent);
            return true;
        }
        if (event.getTopic().startsWith("command.execute.noresponse")) {
            try {
                Runtime.getRuntime().exec(event.getBody());
            }
            catch (IOException e) {
                Activator.getLog().log(1, "Error while executing linux shell command: " + event.getBody() + "\n", (Throwable)e);
            }
            return true;
        }
        if (event.getTopic().startsWith("event") && event.getTopic().endsWith("configure.wlan")) {
            block12: {
                WLANConfigDTO wlanConfig = null;
                Object o = null;
                try {
                    o = this.mappingService.mapToObject(event.getBody(), WLANConfigDTO.class);
                    if (!o.getClass().equals(WLANConfigDTO.class)) break block12;
                    wlanConfig = (WLANConfigDTO)o;
                    String networkConfig = "\nnetwork={\n  ssid=\"" + wlanConfig.getSSID() + "\"\n  psk=\"" + wlanConfig.getPassword() + "\"\n}\n";
                    try {
                        Files.write(Paths.get("/etc/wpa_supplicant/wpa_supplicant.conf", new String[0]), networkConfig.getBytes(), StandardOpenOption.APPEND);
                    }
                    catch (IOException e) {
                        Activator.getLog().log(1, "File not found: /etc/wpa_supplicant/wpa_supplicant.conf", (Throwable)e);
                        return false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        return true;
    }

    public void setMappingService(MappingService mappingService) {
        this.mappingService = mappingService;
    }

    public void setMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
    }
}

