/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.service.io.xmpp;

import com.starbase.core.communication.api.AddressService;
import com.starbase.core.communication.api.AddressServiceAware;
import com.starbase.core.communication.api.CommunicationService;
import com.starbase.core.config.api.ConfiguredService;
import com.starbase.core.crypto.api.CryptoServiceAware;
import com.starbase.core.logger.LogServiceTracker;
import com.starbase.core.mapping.api.MappingService;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.messaging.api.MessageConsumer;
import com.starbase.core.messaging.api.MessagingService;
import com.starbase.core.messaging.api.MessagingServiceAware;
import com.starbase.service.io.xmpp.impl.XMPPCommunicationServiceImpl;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogService;

public class Activator
implements BundleActivator,
MessagingServiceAware,
MappingServiceAware,
AddressServiceAware {
    public static final String SERVICE_PID = "com.starbase.service.io.xmpp";
    private static BundleContext context;
    private static LogServiceTracker logServiceTracker;
    private XMPPCommunicationServiceImpl xmppService;
    private static MessagingService messagingService;
    private static MappingService mappingService;
    private static AddressService addressService;

    public static AddressService getAddressService() {
        return addressService;
    }

    public static MessagingService getMessagingService() {
        return messagingService;
    }

    public static String getServicePid() {
        return SERVICE_PID;
    }

    public static MappingService getMappingService() {
        return mappingService;
    }

    public static BundleContext getContext() {
        return context;
    }

    public static LogService getLog() {
        return logServiceTracker == null ? null : logServiceTracker.getService();
    }

    public void start(BundleContext context) throws Exception {
        Activator.context = context;
        logServiceTracker = new LogServiceTracker(context);
        logServiceTracker.open();
        this.xmppService = new XMPPCommunicationServiceImpl();
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("service.pid", SERVICE_PID);
        ((Dictionary)properties).put("topic", new String[]{"out.xmpp.*"});
        context.registerService(new String[]{MessagingServiceAware.class.getName(), MappingServiceAware.class.getName(), AddressServiceAware.class.getName()}, (Object)this, null);
        context.registerService(new String[]{MessageConsumer.class.getName(), CommunicationService.class.getName(), ConfiguredService.class.getName(), ManagedService.class.getName(), CryptoServiceAware.class.getName()}, (Object)this.xmppService, properties);
        this.xmppService.start();
    }

    public void stop(BundleContext context) throws Exception {
        this.xmppService.stop();
        Activator.getLog().log(4, context.getBundle().getSymbolicName() + " stopped.");
        logServiceTracker.close();
        Activator.context = null;
    }

    public void setMappingService(MappingService mappingService) {
        Activator.mappingService = mappingService;
    }

    public void setMessagingService(MessagingService messagingService) {
        Activator.messagingService = messagingService;
    }

    public void setAddressService(AddressService addressService) {
        Activator.addressService = addressService;
    }
}

