/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.service.io.xmpp.com.iq;

import com.starbase.core.DTOFactory;
import com.starbase.core.communication.dto.AddressDTO;
import com.starbase.core.crypto.api.CipherMode;
import com.starbase.core.exception.io.ContentTooLongException;
import com.starbase.core.messaging.dto.EventDTO;
import com.starbase.service.io.xmpp.Activator;
import com.starbase.service.io.xmpp.com.iq.EventIQ;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;

public class EventIQListener
implements PacketListener {
    EventIQ reply = null;
    XMPPConnection connection = null;

    public EventIQListener(XMPPConnection con) {
        this.connection = con;
    }

    public void processPacket(Packet packet) {
        if (packet instanceof EventIQ) {
            EventIQ receivedIQ = (EventIQ)packet;
            String data = receivedIQ.getData();
            Activator.getLog().log(4, "Received event: " + data + ". From: " + receivedIQ.getFrom() + ". PacketID: " + packet.getPacketID() + ". Type: " + receivedIQ.getType() + ".");
            if (receivedIQ.getType() == IQ.Type.GET || receivedIQ.getType() == IQ.Type.SET) {
                this.reply = new EventIQ();
                this.reply.setType(IQ.Type.RESULT);
                this.reply.setPacketID(packet.getPacketID());
                this.reply.setFrom(packet.getTo());
                this.reply.setTo(packet.getFrom());
                this.reply.setData("Acknowledge for: " + packet.getPacketID());
                EventDTO event = DTOFactory.createEvent((String)"", (String)"", (String)"", (CipherMode)CipherMode.PLAIN, (String)"Unable to restore message");
                try {
                    event = (EventDTO)Activator.getMappingService().mapToObject(data, EventDTO.class);
                }
                catch (Exception e) {
                    Activator.getLog().log(1, "mapping error", (Throwable)e);
                    this.reply.setData("Mapping error for: " + packet.getPacketID());
                    this.connection.sendPacket((Packet)this.reply);
                }
                Set addressListByTechnology = Activator.getAddressService().getAddressListByTechnology(Activator.getServicePid()).entrySet();
                for (Map.Entry entry : addressListByTechnology) {
                    if (((AddressDTO)entry.getValue()).getTo().equals(event.getFrom())) {
                        try {
                            event.setFrom((String)entry.getKey());
                        }
                        catch (ContentTooLongException contentTooLongException) {
                            // empty catch block
                        }
                    }
                    if (!((AddressDTO)entry.getValue()).getTo().equals(event.getTo())) continue;
                    try {
                        event.setTo((String)entry.getKey());
                    }
                    catch (ContentTooLongException contentTooLongException) {}
                }
                if (event.getCipherState().equals((Object)CipherMode.PLAIN)) {
                    Activator.getLog().log(3, "Publishing to: in.xmpp." + event.getTopic());
                    Activator.getMessagingService().publishMessage("in.xmpp." + event.getTopic(), event);
                } else {
                    Activator.getLog().log(3, "Publishing to: " + event.getCipherState().toString().toLowerCase() + ".in.xmpp." + event.getTopic());
                    Activator.getMessagingService().publishMessage(event.getCipherState().toString().toLowerCase() + ".in.xmpp." + event.getTopic(), event);
                }
                this.connection.sendPacket((Packet)this.reply);
            } else if (receivedIQ.getType() == IQ.Type.RESULT && !data.contains("Acknowledge")) {
                Activator.getLog().log(1, "EventIQ with ID: " + packet.getPacketID() + " has not been acknowledged.");
            }
        }
    }
}

