/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.service.io.xmpp.impl;

import com.starbase.core.communication.api.CommunicationService;
import com.starbase.core.communication.dto.AddressDTO;
import com.starbase.core.config.api.ConfiguredService;
import com.starbase.core.crypto.api.CryptoService;
import com.starbase.core.crypto.api.CryptoServiceAware;
import com.starbase.core.exception.io.ContentTooLongException;
import com.starbase.core.messaging.api.MessageConsumer;
import com.starbase.core.messaging.dto.EventDTO;
import com.starbase.service.io.xmpp.Activator;
import com.starbase.service.io.xmpp.com.iq.EventIQ;
import com.starbase.service.io.xmpp.com.iq.EventIQFilter;
import com.starbase.service.io.xmpp.com.iq.EventIQListener;
import com.starbase.service.io.xmpp.com.iq.EventIQProvider;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.net.SocketFactory;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.provider.ProviderManager;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class XMPPCommunicationServiceImpl
implements MessageConsumer,
CommunicationService,
ManagedService,
ConfiguredService,
CryptoServiceAware {
    private static XMPPConnection connection = null;
    private static ConnectionConfiguration config = null;
    private Dictionary<String, ?> configProperties;
    private CryptoService cryptoService;
    private static final int packetReplyTimeout = 500;
    private Thread runner;
    private boolean running;
    private boolean forceReconnect = true;

    public static XMPPConnection getConnection() {
        return connection;
    }

    public void start() {
        this.runner = new Thread(new Runnable(){

            @Override
            public void run() {
                while (XMPPCommunicationServiceImpl.this.running) {
                    XMPPCommunicationServiceImpl.this.checkConnection();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
        this.runner.start();
        this.running = true;
    }

    protected void checkConnection() {
        if (this.forceReconnect && this.configProperties != null) {
            Activator.getLog().log(4, "forcing reconnect...");
            String server = (String)this.configProperties.get("serverIP");
            String port = (String)this.configProperties.get("port");
            String usernameID = (String)this.configProperties.get("username");
            String password = (String)this.configProperties.get("password");
            String useTLS = (String)this.configProperties.get("useTLS");
            if (connection != null && connection.isConnected()) {
                connection.disconnect();
                Activator.getLog().log(4, "Old XMPP connection disconnected.");
            }
            Activator.getLog().log(3, "Initializing connection to server '" + server + "' port '" + port + "'.");
            SmackConfiguration.setPacketReplyTimeout((int)500);
            config = new ConnectionConfiguration(server, Integer.parseInt(port));
            config.setSASLAuthenticationEnabled(false);
            if (useTLS != null && (useTLS.equalsIgnoreCase("true") || useTLS.equalsIgnoreCase("yes"))) {
                if (this.cryptoService != null) {
                    config.setSecurityMode(ConnectionConfiguration.SecurityMode.enabled);
                    config.setSocketFactory((SocketFactory)this.cryptoService.getSSLContext().getSocketFactory());
                } else {
                    Activator.getLog().log(2, "unable to create a secure connection, crypto service is not available");
                }
            } else {
                config.setSecurityMode(ConnectionConfiguration.SecurityMode.disabled);
            }
            connection = new XMPPConnection(config);
            try {
                connection.connect();
                this.forceReconnect = false;
            }
            catch (XMPPException e) {
                Activator.getLog().log(1, "XMPP could not connect to server '" + server + "' with port '" + port + "'.");
                return;
            }
            ProviderManager.getInstance().addIQProvider("query", "starbaseevent", (Object)new EventIQProvider());
            connection.addPacketListener((PacketListener)new EventIQListener(connection), (PacketFilter)new EventIQFilter());
            String username = Activator.getAddressService().getAddress(usernameID).getTo().split("@")[0];
            XMPPCommunicationServiceImpl.performLogin(username, password);
        }
    }

    public void stop() {
        this.running = false;
        if (XMPPCommunicationServiceImpl.getConnection() != null) {
            XMPPCommunicationServiceImpl.getConnection().disconnect();
            Activator.getLog().log(3, "XMPP disconnected");
        }
        if (this.runner != null && this.runner.isAlive()) {
            this.runner.interrupt();
        }
    }

    public void push(EventDTO event, String topic) {
        AddressDTO toAddress = Activator.getAddressService().getAddress(event.getTo());
        this.sendMessage(toAddress, event);
    }

    public boolean sendMessage(AddressDTO address, EventDTO message) {
        Activator.getLog().log(4, "Sending message with XMPP.");
        try {
            String newFrom = Activator.getAddressService().getAddress(message.getFrom()).getTo();
            message.setFrom(newFrom);
            String newTo = Activator.getAddressService().getAddress(message.getTo()).getTo();
            message.setTo(newTo);
        }
        catch (ContentTooLongException | NullPointerException newFrom) {
            // empty catch block
        }
        EventIQ.setDefaultXmlns((String)"starbaseevent");
        EventIQ request = new EventIQ();
        try {
            request.setData(Activator.getMappingService().mapToString((Object)message));
        }
        catch (Exception e) {
            Activator.getLog().log(1, "mapping error", (Throwable)e);
            return false;
        }
        request.setType(IQ.Type.GET);
        request.setTo(address.getTo());
        connection.sendPacket((Packet)request);
        return true;
    }

    public void updated(Dictionary<String, ?> newProperties) throws ConfigurationException {
        if (newProperties == null) {
            Activator.getLog().log(2, "Configuration properties are null.");
            return;
        }
        Activator.getLog().log(4, "trying to update xmpp connection settings to " + newProperties);
        if (this.configProperties != null) {
            if (newProperties.get("username") != null && !newProperties.get("username").equals(this.configProperties.get("username"))) {
                this.forceReconnect = true;
            }
            if (newProperties.get("password") != null && !newProperties.get("password").equals(this.configProperties.get("password"))) {
                this.forceReconnect = true;
            }
            if (newProperties.get("serverDomain") != null && !newProperties.get("serverDomain").equals(this.configProperties.get("serverDomain"))) {
                this.forceReconnect = true;
            }
            if (newProperties.get("serverIP") != null && !newProperties.get("serverIP").equals(this.configProperties.get("serverIP"))) {
                this.forceReconnect = true;
            }
            if (newProperties.get("port") != null && !newProperties.get("port").equals(this.configProperties.get("port"))) {
                this.forceReconnect = true;
            }
            if (newProperties.get("useTLS") != null && !newProperties.get("useTLS").equals(this.configProperties.get("useTLS"))) {
                this.forceReconnect = true;
            }
        } else {
            this.forceReconnect = true;
        }
        this.configProperties = newProperties;
    }

    private static void performLogin(String username, String password) {
        if (!connection.isConnected()) {
            Activator.getLog().log(1, "XmppManager is not connected to server!");
        } else if (!connection.isAuthenticated()) {
            try {
                connection.login(username, password);
                Activator.getLog().log(3, "Logging in user " + username + ".");
            }
            catch (XMPPException e) {
                Activator.getLog().log(1, "Error while logging in user " + username + " to XMPP server.");
                e.printStackTrace();
            }
        } else {
            connection.disconnect();
            try {
                connection.connect();
                connection.login(username, password);
                Activator.getLog().log(3, "Logging in user " + username + ".");
            }
            catch (XMPPException e) {
                Activator.getLog().log(1, "Error while logging in user " + username + " to XMPP server.");
                e.printStackTrace();
            }
        }
    }

    public Dictionary<String, ?> getDefaultConfiguration() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("username", "this.xmpp");
        ((Dictionary)properties).put("password", "starbase");
        ((Dictionary)properties).put("serverDomain", "entrust");
        ((Dictionary)properties).put("serverIP", "192.168.1.203");
        ((Dictionary)properties).put("port", "5222");
        ((Dictionary)properties).put("useTLS", "false");
        return properties;
    }

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }
}

