/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.service.log.file.impl;

import com.starbase.core.Utilities;
import com.starbase.core.config.api.ConfiguredService;
import com.starbase.core.exception.general.NotFoundException;
import com.starbase.service.log.file.Activator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

public class SimpleFileLogger
implements LogListener,
ConfiguredService,
ManagedService {
    private PrintWriter printWriter;
    private String fileName = "./log.txt";
    private String logLevelConfig = "2";
    private boolean printException = false;

    private void openFileIfClosed() throws Exception {
        if (this.printWriter != null) {
            return;
        }
        File file = new File(this.fileName);
        try {
            this.printWriter = new PrintWriter(new FileOutputStream(file, true));
        }
        catch (FileNotFoundException e) {
            throw new NotFoundException("unable to open file" + file, (Throwable)e);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public void logged(LogEntry entry) {
        int currentLevel = entry.getLevel();
        if (entry.getMessage().startsWith("ServiceEvent") || entry.getMessage().startsWith("BundleEvent") || entry.getMessage().startsWith("FrameworkEvent")) {
            currentLevel = 5;
        }
        if (entry.getMessage().equals("getProperties()") && entry.getBundle().getSymbolicName().equals("org.apache.felix.configadmin")) {
            return;
        }
        if (currentLevel <= Utilities.getLogLevelForBundle((Bundle)entry.getBundle(), (String)this.logLevelConfig)) {
            try {
                this.openFileIfClosed();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.printWriter != null) {
                DateTimeFormatter timeStampPattern = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
                String timeString = timeStampPattern.format(LocalDateTime.now());
                this.printWriter.println(timeString + "|" + Utilities.getLogLevel((int)currentLevel) + ":" + entry.getBundle().getSymbolicName() + " " + entry.getBundle().getBundleId() + "> " + entry.getMessage());
                if (this.printException && entry.getException() != null) {
                    entry.getException().printStackTrace(this.printWriter);
                }
                this.printWriter.flush();
            }
        }
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties == null) {
            return;
        }
        if (Utilities.getLogLevelForBundle((Bundle)Activator.getContext().getBundle(), (String)this.logLevelConfig) >= 3) {
            System.out.println("INFO:com.starbase.service.log.file> configuring logger " + properties);
        }
        if (properties.get("level") != null) {
            this.logLevelConfig = properties.get("level").toString();
        }
        if (properties.get("print_exception") != null) {
            boolean exception = false;
            try {
                exception = Boolean.valueOf(properties.get("print_exception").toString());
            }
            catch (Exception exception2) {
                // empty catch block
            }
            this.printException = exception;
        }
        if (properties.get("file") != null) {
            if (this.printWriter != null) {
                this.printWriter.close();
                this.printWriter = null;
            }
            this.fileName = properties.get("file").toString();
        }
    }

    public Dictionary<String, ?> getDefaultConfiguration() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("level", "1");
        ((Dictionary)properties).put("print_exception", "false");
        ((Dictionary)properties).put("file", "./log.txt");
        return properties;
    }
}

