/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.service.messaging.rabbitmq;

import com.starbase.core.config.api.ConfiguredService;
import com.starbase.core.crypto.api.CryptoServiceAware;
import com.starbase.core.logger.LogServiceTracker;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.service.messaging.rabbitmq.impl.RabbitMQMessagingServiceImpl;
import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogService;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private static LogServiceTracker logServiceTracker;
    private RabbitMQMessagingServiceImpl messagingServiceImpl;

    public static LogService getLog() {
        return logServiceTracker == null ? null : logServiceTracker.getService();
    }

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        logServiceTracker = new LogServiceTracker(context);
        logServiceTracker.open();
        this.messagingServiceImpl = new RabbitMQMessagingServiceImpl();
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.pid", "com.starbase.service.messaging.rabbitmq");
        context.registerService(new String[]{CryptoServiceAware.class.getName(), ManagedService.class.getName(), ConfiguredService.class.getName(), MappingServiceAware.class.getName()}, (Object)this.messagingServiceImpl, properties);
        this.messagingServiceImpl.start();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.messagingServiceImpl.stop();
        logServiceTracker.close();
        context = null;
    }
}

