/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.service.messaging.rabbitmq.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.starbase.core.DTOFactory;
import com.starbase.core.config.api.ConfiguredService;
import com.starbase.core.crypto.api.CipherMode;
import com.starbase.core.crypto.api.CryptoService;
import com.starbase.core.crypto.api.CryptoServiceAware;
import com.starbase.core.mapping.api.MappingService;
import com.starbase.core.mapping.api.MappingServiceAware;
import com.starbase.core.messaging.api.MessageConsumer;
import com.starbase.core.messaging.api.MessagingService;
import com.starbase.core.messaging.dto.EventDTO;
import com.starbase.service.messaging.rabbitmq.Activator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class RabbitMQMessagingServiceImpl
implements CryptoServiceAware,
MessagingService,
ManagedService,
ConfiguredService,
MappingServiceAware {
    private static final String EXCHANGE_NAME = "starbase";
    private ConnectionFactory factory = new ConnectionFactory();
    private Connection connection;
    private String useSSL = "no";
    private Hashtable<MessageConsumer, Receiver> receiver = new Hashtable();
    private Thread keepAliveThread = new Thread(new Runnable(){

        @Override
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    RabbitMQMessagingServiceImpl.this.checkConnection();
                    Thread.sleep(2000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    });
    private boolean forceReconnect;
    private MappingService mappingService;
    private CryptoService cryptoService;

    public void start() {
        this.forceReconnect = true;
        Activator.getContext().registerService(MessagingService.class, (Object)this, null);
        this.keepAliveThread.start();
    }

    public void stop() {
        this.keepAliveThread.interrupt();
        if (this.connection != null && this.connection.isOpen()) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void checkConnection() {
        if (this.connection != null && this.connection.isOpen() && !this.forceReconnect) {
            return;
        }
        this.closeConnection();
        this.setFactorySSLContext();
        try {
            this.connection = this.factory.newConnection();
            this.forceReconnect = false;
            this.reconnectReceivers();
            Activator.getLog().log(3, "RabbitMQ reconnected");
        }
        catch (IOException | TimeoutException e) {
            Activator.getLog().log(2, "unable to connect to " + this.factory.getHost(), (Throwable)e);
        }
    }

    private void closeConnection() {
        Enumeration<MessageConsumer> keys = this.receiver.keys();
        while (keys.hasMoreElements()) {
            MessageConsumer messageConsumer = keys.nextElement();
            Receiver rec = this.receiver.get(messageConsumer);
            if (rec == null || rec.channel == null || !rec.channel.isOpen()) continue;
            try {
                rec.channel.close();
            }
            catch (IOException | TimeoutException exception) {}
        }
        if (this.connection != null && this.connection.isOpen()) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void reconnectReceivers() {
        Hashtable<MessageConsumer, Receiver> recCopy = new Hashtable<MessageConsumer, Receiver>(this.receiver);
        this.receiver = new Hashtable();
        Enumeration<MessageConsumer> keys = recCopy.keys();
        while (keys.hasMoreElements()) {
            MessageConsumer messageConsumer = keys.nextElement();
            Receiver rec = recCopy.get(messageConsumer);
            String[] topics = rec.topics.toArray(new String[rec.topics.size()]);
            this.addSubscriber(messageConsumer, topics);
        }
    }

    private void setFactorySSLContext() {
        if (!this.useSSL.equals("no") && !this.useSSL.equals("")) {
            SSLContext c = this.cryptoService.getSSLContext();
            if (c == null) {
                Activator.getLog().log(1, "SSL failed");
                return;
            }
            this.factory.useSslProtocol(c);
        }
    }

    public Dictionary<String, ?> getDefaultConfiguration() {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("host", "mq.starballsports.com");
        ((Dictionary)properties).put("port", "5671");
        ((Dictionary)properties).put("username", "starballmq");
        ((Dictionary)properties).put("password", "0WMHZasVXOsSbArUrImE");
        ((Dictionary)properties).put("ssl", "yes");
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean publishMessage(String topic, EventDTO event) {
        if (this.connection == null) {
            Activator.getLog().log(2, "could not send message because rabbitmq is not connected");
            return false;
        }
        Channel channel = null;
        try {
            channel = this.connection.createChannel();
            channel.exchangeDeclare(EXCHANGE_NAME, "topic");
            String message = this.mappingService.mapToString((Object)event);
            channel.basicPublish(EXCHANGE_NAME, topic, null, message.getBytes());
            channel.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            Activator.getLog().log(1, "error while connecting to RabbitMQ", (Throwable)e);
        }
        catch (TimeoutException e) {
            Activator.getLog().log(1, "timeout while connecting to RabbitMQ", (Throwable)e);
        }
        catch (Exception e) {
            Activator.getLog().log(1, "error while mapping event to string", (Throwable)e);
        }
        finally {
            if (channel != null && channel.isOpen()) {
                try {
                    channel.close();
                }
                catch (IOException | TimeoutException e) {}
            }
        }
        return false;
    }

    public void addSubscriber(final MessageConsumer consumer, String[] topics) {
        Receiver currentReceiver = new Receiver().setTopics(topics);
        this.receiver.put(consumer, currentReceiver);
        if (this.connection == null || !this.connection.isOpen()) {
            Activator.getLog().log(3, "subscriber " + consumer.getClass() + " added, but connection is not established yet");
            return;
        }
        try {
            Channel channel = this.connection.createChannel();
            channel.exchangeDeclare(EXCHANGE_NAME, "topic");
            String queueName = channel.queueDeclare().getQueue();
            for (String bindingKey : topics) {
                channel.queueBind(queueName, EXCHANGE_NAME, RabbitMQMessagingServiceImpl.topicToRabbitMQFormat(bindingKey));
            }
            DefaultConsumer rabbitConsumer = new DefaultConsumer(channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    String message = new String(body, "UTF-8");
                    EventDTO event = DTOFactory.createEvent((String)envelope.getRoutingKey(), (String)"", (String)"", (CipherMode)CipherMode.PLAIN, (String)message);
                    try {
                        event = (EventDTO)RabbitMQMessagingServiceImpl.this.mappingService.mapToObject(message, EventDTO.class);
                    }
                    catch (Exception e) {
                        Activator.getLog().log(2, "could not map message to event", (Throwable)e);
                    }
                    consumer.push(event, envelope.getRoutingKey());
                }
            };
            channel.basicConsume(queueName, true, (Consumer)rabbitConsumer);
            currentReceiver.setChannel(channel).setConsumer((Consumer)rabbitConsumer).setQueueName(queueName);
        }
        catch (Exception e) {
            Activator.getLog().log(2, "error while adding subscriber", (Throwable)e);
        }
    }

    public void removeSubscriber(MessageConsumer consumer, String[] filter) {
        Channel channel = null;
        try {
            Receiver receiverObject = this.receiver.get(consumer);
            channel = receiverObject.channel;
            for (String routingKey : filter) {
                channel.queueUnbind(receiverObject.queueName, EXCHANGE_NAME, routingKey);
                receiverObject.topics.remove(routingKey);
            }
            if (receiverObject.topics.size() == 0) {
                this.receiver.remove(consumer);
                channel.close();
            }
        }
        catch (Exception e) {
            Activator.getLog().log(1, "exception while removing subscriber from RabbitMQ: ", (Throwable)e);
        }
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        Activator.getLog().log(3, "trying to update rabbitmq settings to " + properties);
        if (properties == null) {
            return;
        }
        if (properties.get("host") != null) {
            this.factory.setHost(properties.get("host").toString());
            this.forceReconnect = true;
        }
        if (properties.get("port") != null) {
            this.factory.setPort(Integer.valueOf(properties.get("port").toString()).intValue());
            this.forceReconnect = true;
        }
        if (properties.get("password") != null) {
            this.factory.setPassword(properties.get("password").toString());
            this.forceReconnect = true;
        }
        if (properties.get("username") != null) {
            this.factory.setUsername(properties.get("username").toString());
            this.forceReconnect = true;
        }
        if (properties.get("ssl") != null) {
            this.useSSL = properties.get("ssl").toString();
            this.forceReconnect = true;
        }
    }

    private static String topicToRabbitMQFormat(String in) {
        String out = in.replace('*', '#');
        out = out.replace('?', '*');
        return out;
    }

    public void setMappingService(MappingService mappingService) {
        this.mappingService = mappingService;
    }

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    class Receiver {
        String queueName;
        Consumer consumer;
        Channel channel;
        ArrayList<String> topics;

        Receiver() {
        }

        public Receiver setTopics(ArrayList<String> topics) {
            this.topics = topics;
            return this;
        }

        public Receiver setTopics(String[] topics) {
            this.topics = new ArrayList<String>(Arrays.asList(topics));
            return this;
        }

        public Receiver setQueueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public Receiver setConsumer(Consumer consumer) {
            this.consumer = consumer;
            return this;
        }

        public Receiver setChannel(Channel channel) {
            this.channel = channel;
            return this;
        }
    }
}

